LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY inv IS
  PORT( a : IN std_logic;
        b : OUT std_logic);
END inv;

ARCHITECTURE behave OF inv IS
BEGIN
  b <= NOT(a) AFTER 5 ns;
END behave;

CONFIGURATION invcon OF inv IS
  FOR behave
  END FOR;
END invcon;

LIBRARY IEEE; USE IEEE.std_logic_1164.ALL;
ENTITY and3 IS
  PORT( a1, a2, a3 : IN std_logic;
        o1 : OUT std_logic);
END and3;

ARCHITECTURE behave OF and3 IS
BEGIN
  o1 <= a1 AND a2 AND a3 AFTER 5 ns;
END behave;

CONFIGURATION and3con OF and3 IS
  FOR behave
  END FOR;
END and3con;




LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY decode IS
  PORT( a, b, en : IN std_logic;
        q0, q1, q2, q3 : OUT std_logic);
END decode;

ARCHITECTURE structural OF decode IS
  COMPONENT inv
    PORT( a : IN std_logic;
          b : OUT std_logic);
  END COMPONENT;

  COMPONENT and3
    PORT( a1, a2, a3 : IN std_logic;
          o1 : OUT std_logic);
  END COMPONENT;

  SIGNAL nota, notb : std_logic;
BEGIN
  I1 : inv
    PORT MAP(a, nota);

  I2 : inv
    PORT MAP(b, notb);

  A1 : and3
    PORT MAP(nota, en, notb, Q0);

  A2 : and3
    PORT MAP(a, en, notb, Q1);

  A3 : and3
    PORT MAP(nota, en, b, Q2);

  A4 : and3 
    PORT MAP(a, en, b, Q3);

END structural;




CONFIGURATION decode_llcon OF decode IS
  FOR structural
    FOR I1 : inv USE CONFIGURATION WORK.invcon;
    END FOR;

    FOR I2 : inv USE CONFIGURATION WORK.invcon;
    END FOR;

    FOR ALL : and3 USE CONFIGURATION WORK.and3con;
    END FOR;
  END FOR;
END decode_llcon;



CONFIGURATION decode_eacon OF decode IS
  FOR structural
    FOR I1 : inv USE ENTITY WORK.inv(behave);
    END FOR;

    FOR OTHERS : inv USE ENTITY WORK.inv(behave);
    END FOR;

    FOR A1 : and3 USE ENTITY WORK.and3(behave);
    END FOR;

    FOR OTHERS : and3 USE ENTITY WORK.and3(behave);
    END FOR;

  END FOR;
END decode_eacon;


